unit MediaPlu;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MPlayer, Menus, ComCtrls;

type
  TMediaFrm = class(TForm)
    MediaPlayer1: TMediaPlayer;
    btnMegnyitas: TButton;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    mnFajl: TMenuItem;
    mnuKilepes: TMenuItem;
    AllapotSor: TStatusBar;
    mnuMegnyitas: TMenuItem;
    mnuSeparator: TMenuItem;
    Timer1: TTimer;
    TrackBar1: TTrackBar;
    procedure btnMegnyitasClick(Sender: TObject);
    procedure mnuKilepesClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
  private
    procedure felirat;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MediaFrm: TMediaFrm;

implementation
{$R *.DFM}

procedure TMediaFrm.btnMegnyitasClick(Sender: TObject);
 var
   ext, hibaStr: string;
   sav: longint;
 begin
   if OpenDialog1.Execute then // ha kivlasztottunk egy fjlt
     begin
       if MediaPlayer1.DeviceID<>0 then  // ha van megnyitott mdiaeszkz
         begin
           MediaPlayer1.Stop; // lejtszs lelltsa
           MediaPlayer1.Close;
         end;
       // az llapotsor felirata
       AllapotSor.Panels.Items[0].Text := OpenDialog1.FileName + '  lejtszsa';

       ext:= AnsiUpperCase(ExtractFileExt(OpenDialog1.FileName));
       if ext='.CDA' // a fjl - egy hangsv ("zeneszm") a zenei CD-n
         then
           begin
             MediaPlayer1.DeviceType := dtCDAudio;  //a lejtsz tpusnak belltsa
             try
               MediaPlayer1.Open;  //a csatorna nyitsa
             except
               hibaStr := 'Hibakd: ' + IntToStr(Error) + #13#10;
               MessageDlg(hibaStr + MediaPlayer1.ErrorMessage, mtError, [mbOk], 0);
             end;

             // a kivlasztott hangsv sorszma:
             sav:= StrToInt(Copy(OpenDialog1.FileName, Length(OpenDialog1.FileName)-5, 2));
             MediaPlayer1.Position := MediaPlayer1.TrackPosition[sav]; // pozicionls
             AllapotSor.Panels.Items[0].Text := 'Zenei CD lejtszsa, ' + IntToStr(sav) + '. sv'; // feliratozs
           end
         else // ha nem egy CD-n lev hangsvot vlasztottunk ki a prbeszdablakbl
           begin
             AllapotSor.Panels.Items[0].Text := 'Nincs megnyitott CD-hangsv.';
             AllapotSor.Panels.Items[1].Text := '';
             AllapotSor.Panels.Items[2].Text := '';
           end;
      end;
end;

procedure TMediaFrm.mnuKilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TMediaFrm.Timer1Timer(Sender: TObject);
var
  perc, mperc : Longint;
begin
  case MediaPlayer1.TimeFormat of
   tfTMSF:  //  CD
      begin
        perc:= (MediaPlayer1.Position shl 16) shr 24;
        mperc:= (MediaPlayer1.Position shl 8) shr 24;
        TrackBar1.Position:= mperc + perc*60;
        AllapotSor.Panels.Items[1].Text:=Format('%2d:%2d',[perc,mperc]);
        if (perc=0) and (mperc<1)  then felirat;
       end;
   else
      begin
        TrackBar1.Position := MediaPlayer1.Position;
        AllapotSor.Panels.Items[1].Text:=IntToStr(MediaPlayer1.Position);
      end;
  end;

  if AllapotSor.Panels.Items[1].Text = AllapotSor.Panels.Items[2].Text then
    TrackBar1.Position:=0;
end;


procedure TMediaFrm.felirat();
var
 sav, perc, mperc : Longint;
begin
  case MediaPlayer1.TimeFormat of
   tfTMSF:  //  CD
      begin
        sav:= (MediaPlayer1.Position shl 24) shr 24;
        perc:= (MediaPlayer1.TrackLength[sav] shl 24) shr 24;
        mperc:= (MediaPlayer1.TrackLength[sav] shl 16) shr 24;
        TrackBar1.Max :=  mperc + perc*60;   // sncsuszka vgrtknek megadsa
        AllapotSor.Panels.Items[0].Text := 'Zenei CD lejtszsa, ' + IntToStr(sav) + '. sv';
        AllapotSor.Panels.Items[2].Text:=Format('%2d:%2d',[perc,mperc]);  // idhossz
      end;
   else
      begin
        TrackBar1.Max := MediaPlayer1.Length;  // sncsuszka vgrtknek megadsa
        AllapotSor.Panels.Items[2].Text:=IntToStr(MediaPlayer1.Length);
      end;
  end;
end;


procedure TMediaFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if MediaPlayer1.DeviceID<>0 then
   begin
    MediaPlayer1.Stop;
    MediaPlayer1.Close;
   end;
end;

procedure TMediaFrm.MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  case Button of
    btPlay:  // ha a Play gombra kattintottunk
     begin
       Timer1.Interval:=(TrackBar1.Max div TrackBar1.Width)+1;
       Timer1.Enabled:=true;
       felirat();
     end;
  end;
end;

end.
